/* -*- Mode:C; Tab-width:4 -*- */
/*                                                                       */
/*                                                                       */
/*                      RESTRICTED RIGHTS LEGEND                         */
/*                                                                       */
/* Use, duplication, or disclosure by the Government is subject to       */
/* restrictions as set forth in subdivision (c)(1)(ii) of the Rights in  */
/* Technical Data and Computer Software clause at 252.227-7013.          */
/*                                                                       */
/*                    TEXAS INSTRUMENTS INCORPORATED.                    */
/*                            P.O. BOX 149149                            */
/*                         AUSTIN, TEXAS 78714-9149                      */
/*                              MS 2151                                  */
/*                                                                       */
/*  Copyright (C)   1987,1988,1989,1990 Texas Instruments Incorporated.  */
/*  All rights reserved.                                                 */
/*                                                                       */

/*  9-28-88   BJ   Move Nupi and Crash register defines here from micronet-device.c.*/
/*  9-28-88   BJ   Added definition of handle_micronet_ports. */
/*  2-23-89   BJ   Added Boolean 24bitmode and AUX_p          */

#include <types.h>

#define LIMPET	1

/* Offsets into MX slot for nupi and microcode ports. */
#define nupi_register 0xff000
#define crash_register 0xff008

extern Boolean in_driver_p; /* Set to true if we are running in the main driver application. */

void handle_micronet_ports();

#define DriverDataOffset 0xff800

#define makemxaddr(addr) (((unsigned long)(DriverData->mx_slot) << 20) | addr)  /* clm 10/10/89 - cast */

#define MAXDOCLINE		129

extern Boolean use24bitmode; /* True if we started and run in 24 bit mode. */
extern Boolean AUX_p; /* true if running under AUX.                    */
extern unsigned int high_8_bits; /* The high 8 bits to a pointer into mx memory. */
typedef struct {
    char validp ;
    Point Pos ;
    short button ;
    short ScreenID ;
} MouseRecord ;

typedef struct
{
	unsigned short validp;
    unsigned short keybuf;
	unsigned short modifiers;
} keybuf;

typedef char mouseDocLine[MAXDOCLINE+1] ;					/* 128 + null + change flag */

typedef struct
{
    unsigned short filler ;					/* force to 32 bit boundary */
    unsigned long total_elapsed_time;
	unsigned long cpu_time;
    unsigned long page_time;
    unsigned long scavenge_time;
	unsigned long total_interval ;			/* lisp only */
	unsigned long cpu_interval;				/* lisp only */
    char state[22];
	char fileState[82] ;
	mouseDocLine mouseDoc[5] ;
} who_state;

struct driver_data
{
  Ptr prime_internal;
  Ptr control_internal;
  Ptr close_internal;
  Ptr a5_value;
  short refnum;                     /* The reference number of the open MicroNet driver. */
  unsigned char my_slot;            /* The slot address of the host processor.           */
  unsigned char mx_slot;          /* The slot address of the MicroExplorer.            */
  unsigned char done_flag:1;
  unsigned char driver_initialized:1;
  unsigned char portmap_initialized:1;
  unsigned char nfs_initialized:1;
  unsigned char unused:4;
  keybuf k;
  MouseRecord lockedMouse;
  who_state w;
};

extern struct driver_data *DriverData;

struct accessor_info
{
  int ch;
  Ptr fn;
  int unused[5];
};

extern Boolean find_host();
extern Boolean find_mx();
extern Boolean find_Driver_data();
extern int initialize_micronet();
extern Boolean add_channel_open();
extern Boolean remove_channel_open();
extern Boolean add_channel_close();
extern Boolean remove_channel_close();
extern Boolean add_channel_handler();
extern Boolean remove_channel_handler();
